define([
    "dojo/_base/declare",
    "thornberry/app/Component/_Component",
    "thornberry/app/Component/_ViewMixin",
    "dijit/_TemplatedMixin",
    "dijit/_WidgetsInTemplateMixin",
    "dojo/text!./Templates/PostingSummaryView.html",
    "dojo/text!./Templates/PostingSummaryItem.html",
    "dojo/_base/lang",
    "dojo/_base/array",
    "dojo/dom-style",
    "thornberry/app/utils",
    "thornberry/report/formatter",
    "dojo/store/Memory",
    "thornberry/app/Service/EnsembleFactory",
    "dijit/form/DateTextBox"
],function(
    declare,
    _Component,
    _ViewMixin,
    _TemplatedMixin,
    _WidgetsInTemplateMixin,
    template,
    itemTemplate,
    lang,
    arrayUtils,
    domStyle,
    utils,
    formatter,
    Memory,
    EnsembleFactory
) {
    var ensembleService = EnsembleFactory("Billing.Claim.EnsembleRequest");

    var structure = [
        { id: "patient", field: "PatientNameID", name: "Patient" },
        { id: "statementPeriod", field: "ClaimStatementPeriod", name: "Statement Period" },
        { id: "insurance", field: "Insurance", name: "Insurance" },
        { id: "type", field: "Type", name: "Type" },
        { id: "gross", field: "GrossRevenue", name: "Gross", formatter: formatter.getForColumn({field:"GrossRevenue"},{formatter:"dollars"}) },
        { id: "net", field: "NetRevenue", name: "Net", formatter: formatter.getForColumn({field:"NetRevenue"},{formatter:"dollars"}) },
        { id: "claimId", field: "Claim ID", name: "Claim ID" }
    ];

    var Item = declare([_Component,_ViewMixin,_TemplatedMixin],{
        templateString: itemTemplate,

        fileLabel: "",
        fileName: "",

        grid: null,

        getInitialProps: function() {
            return lang.mixin(this.inherited(arguments),{
                item: {
                    name: "",
                    claims: []
                },
                number: 0
            });
        },

        postMixInProperties: function() {
            var t = this;
            t.inherited(arguments);

            t.fileLabel = lang.replace("File #{number}",t.props);
            t.fileName = t.props.item.name;
        },

        buildRendering: function() {
            var t = this;
            t.inherited(arguments);
            
            domStyle.set(t.divider,"display",t.props.number > 1 ? "" : "none");

            t.grid = utils.createGrid(structure,t.gridContainer);
            t.grid.model.store.setData(t.props.item.claims);
            t.grid.model.clearCache();
            t.grid.body.refresh();
        },

        resize: function() {
            this.grid.resize();
        }
    });

    return declare([_Component,_ViewMixin,_TemplatedMixin,_WidgetsInTemplateMixin], {
        templateString: template,

        // properties
        title: "Posting Summary",

        claimIds: null,
        ensembleResult: null,
        items: null,

        constructor: function() {
            this.items = [];
        },

        getInitialProps: function() {
            return lang.mixin(this.inherited(arguments),{
                // The component that opens this view should pass EITHER the claimIds OR the claimFileId to be regenerated
                claimIds: null,
                claimFileId: null,
                agingDate: null
            });
        },

        getPageProps: function() {
            var t = this;
            return lang.mixin(t.inherited(arguments),{
                content: t.domNode,
                actions : [
                    { label: "Done", onClick: t.props.onCloseView },
                    { label: "Download", onClick: lang.hitch(t,"download"), hidden: (!t.ensembleResult || !t.ensembleResult.files || !t.ensembleResult.files.length) }
                ]
            });
        },
 
        refreshRendering: function() {
            var t = this;
            if (t.isShown) {
                t.set("claimIds",t.props.claimIds);
                t.set("claimFileId",t.props.claimFileId);
                domStyle.set(t.agingDateContainer,"display",t.props.agingDate ? "" : "none");
                t.agingDateField.set("value",utils.conversions.date("",t.props.agingDate,"set"));
            }
            t.inherited(arguments);
        },
        _setPropsAttr: function(props) {
            var t = this;
            if (t.props && (props.claimIds || props.claimFileId)) {
                delete t.props.claimIds;
                delete t.props.claimFileId;
            }
            t._set("props",lang.mixin({},t.props,props));
        },

        _setClaimIdsAttr: function(value) {
            var t = this;
            if (value && t.claimIds !== value) {
                var promise = ensembleService({claimIds:value}).then(function(result) {
                    t.set("ensembleResult",result);
                },function(error) {
                    t.set("ensembleResult",{});
                    utils.showMessage(error);
                });
                t.addReadyPromise(promise);
                t.props.onSetLoadingPromise(promise);
            }
            t.claimIds = value;
        },

        _setClaimFileIdAttr: function(value) {
            var t = this;
            if (value && t.claimFileId !== value) {
                var promise = ensembleService({claimFileId:value}).then(function(result) {
                    t.set("ensembleResult",result);
                },function(error) {
                    t.set("ensembleResult",{});
                    utils.showMessage(error);
                });
                t.addReadyPromise(promise);
                t.props.onSetLoadingPromise(promise);
            }
            t.claimIds = value;
        },

        _setEnsembleResultAttr: function(value) {
            var t = this;
            t.ensembleResult = value;
            arrayUtils.forEach(t.items,function(widget) {widget.destroy()});
            t.items = [];
            arrayUtils.forEach(value.files,function(file,idx) {
                var item = new Item({props: { item: file, number:idx+1 } });
                t.items.push(item);
                t.itemContainer.appendChild(item.domNode);
            });
			if (!t.items.length) {
                var item = new Item({props: { item: {name: "No files generated", claims: []}, number:0 } });
                t.items.push(item);
                t.itemContainer.appendChild(item.domNode);
			}
        },

        onShow: function() {
            var t = this;
            arrayUtils.forEach(t.items,function(widget) {widget.resize()});
        },

        onBeforeClose: function() {
            var t = this;
            if (t.props.onComplete) {
                t.props.onComplete();
            }
            return true;
        },

        download: function() {
            var t = this;
            utils.promptDownload(t.ensembleResult.fileLinkId);
        }
    });
});